/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UILog;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ShortObjectIdManager
implements UILog {
    public static final int SHORT_ID_LENGTH = 8;
    private HashMap shortObjectId2ObjectId = new HashMap();
    private HashMap objectId2ShortObjectId = new HashMap();
    private int nextShortObjectId = 0;
    private boolean logTaken = false;

    public synchronized String add(ObjectId objectId) throws IndexOutOfBoundsException {
        if (this.nextShortObjectId > Short.MAX_VALUE) {
            IndexOutOfBoundsException exc = new IndexOutOfBoundsException("There are no more short identifiers, next short identifier is " + this.nextShortObjectId + ", maximum value is " + Short.MAX_VALUE);
            if (!this.logTaken) {
                this.logTaken = true;
            }
            throw exc;
        }
        String shortId = (String)this.objectId2ShortObjectId.get(objectId);
        if (shortId == null) {
            if ((shortId = Integer.toHexString(this.nextShortObjectId++).toUpperCase()).length() < 8) {
                char[] temp = new char[8];
                for (int i = 0; i < 8; ++i) {
                    temp[i] = 48;
                }
                char[] c = shortId.toCharArray();
                for (int i = 0; i < c.length; ++i) {
                    temp[temp.length - c.length + i] = c[i];
                }
                shortId = new String(temp);
            }
            this.shortObjectId2ObjectId.put(shortId, objectId);
            this.objectId2ShortObjectId.put(objectId, shortId);
        }
        return shortId;
    }

    public synchronized void add(ObjectId[] objectIds) throws IndexOutOfBoundsException {
        for (int i = 0; i < objectIds.length; ++i) {
            this.add(objectIds[i]);
        }
    }

    public synchronized String getShortId(ObjectId objectId) {
        return (String)this.objectId2ShortObjectId.get(objectId);
    }

    public synchronized ObjectId getObjectId(String shortObjectId) {
        return (ObjectId)this.shortObjectId2ObjectId.get(shortObjectId);
    }

    public synchronized void clear() {
        this.shortObjectId2ObjectId.clear();
        this.objectId2ShortObjectId.clear();
        this.nextShortObjectId = 1;
    }

    public synchronized int getShortIdSize() {
        return this.shortObjectId2ObjectId.size();
    }

    public synchronized int getObjectIdSize() {
        return this.objectId2ShortObjectId.size();
    }

    public synchronized Set getShortIds() {
        HashSet result = new HashSet();
        result.addAll(this.shortObjectId2ObjectId.keySet());
        return result;
    }

    public synchronized Map getShortIds(Collection objectIds) {
        HashMap<ObjectId, String> result = new HashMap<ObjectId, String>();
        Iterator iterator = objectIds.iterator();
        while (iterator.hasNext()) {
            ObjectId next = (ObjectId)iterator.next();
            result.put(next, this.getShortId(next));
        }
        return result;
    }

    public synchronized Set getObjectIds() {
        HashSet result = new HashSet();
        result.addAll(this.objectId2ShortObjectId.keySet());
        return result;
    }

    public synchronized Map getObjectIds(Collection shortIds) {
        HashMap<String, ObjectId> result = new HashMap<String, ObjectId>();
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            result.put(next, this.getObjectId(next));
        }
        return result;
    }
}

